<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Rest extends Controller{

    protected $post;

    public function before(){
        ini_set('memory_limit', '-1');
        ini_set('post_max_size', '20M');
        ini_set('upload_max_filesize', '20M');

        if (Auth::instance()->logged_in() && $_SERVER['HTTP_ACCEPT'] == 'application/json, text/plain, */*'){
            $this->post = json_decode(file_get_contents("php://input"), true);
            return parent::before();
        }

        throw HTTP_Exception::factory(500);
    }

    public function action_utc_timer(){
        $this->response->body(
            DB::select(DB::expr("to_char(NOW(), 'HH24:MI') as now"))
                ->execute()
                ->as_array()[0]['now']
        );
    }

    protected function paginate(&$response, $model, $items_per_page = 10){
        $total = clone $model;
        $total_items = $total->execute()['total_info']['total_found'];
        $pagination = Pagination::factory([
            'total_items' => $total_items,
            'current_page' => [
                'source' => 'route',
                'key' => 'page',
            ],
            'items_per_page' => $items_per_page,
        ]);
        $response['total_items'] = $pagination->getTotalItems();
        $response['current_page'] = $pagination->getCurrentPage();
        $response['items_per_page'] = $pagination->getItemsPerPage();

        return $model->limit($pagination->items_per_page)
            ->offset($pagination->offset);
    }

    protected function getDate($date){
        $date = new DateTime($date);
        return $date->format('Y-m-d H:i:s');
    }
}